(function () {
    var selector = '[data-ergo-lv-page-embed]';
    var iframeSelector = selector + ' iframe';
    var embedContainer = document.querySelector(selector);

    if (embedContainer) {
        var generatedUrl = embedContainer.dataset.baseUrl + window.location.pathname;
        var url = embedContainer.dataset.ergoLvPageEmbed ? embedContainer.dataset.ergoLvPageEmbed : generatedUrl;
        embedContainer.innerHTML = '<iframe src="' + url + '"' +
            ' frameborder="0" scrolling="no" width="100%" height="100%"></iframe>';
    }

    window.addEventListener('message', function (event) {
        try {
            var data = JSON.parse(event.data);
        } catch (e) {
            return;
        }
        if (data.action && data.action === 'EmbedChildUpdated') {
            var iframe = document.querySelector(iframeSelector);
            iframe.style.height = data.height + 'px';
            iframe.style.width = '100%';
        }
    });
}());

