(function()
{
    'use strict';

    var page = jQuery(document);

    var is_entirely_visible = function(element)
    {
        if (element instanceof jQuery == false)
        {
            element = jQuery(element);
        }

        var offset = element.offset();
        var width  = element.width();
        var viewport = jQuery(window).width();

        var is_entirely_visible = ((offset.left + width) <= viewport);

        if (is_entirely_visible)
        {
            return true;
        }

        return false;
    };

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        if (!block.is(page))
        {
            return;
        }

        var header = block.find('body > header');
        var menubox = header.find('.navigations.primary');
        var menus   = header.find('nav.modes > ul, nav.main > ul');
        var toggles = header.find('button.toggle');

        var open_suffix = '-open';

        var navigations = toggles.map(function(index, element)
        {
            return jQuery(element).data('target');
        })

        var is_any_navigation_open = function()
        {
            var is_open;

            jQuery.each(navigations, function(index, value)
            {
                is_open = header.is('.' + value + open_suffix);

                if (is_open)
                {
                    return;
                }
            });

            return is_open;
        };

        var close_navigations = function()
        {
            jQuery.each(navigations, function(index, value)
            {
                if (!header.is('.' + value + open_suffix))
                {
                    return;
                }

                page.trigger('navigation:close', value);
            });

            menus.trigger('navigationitem:closeall');
        };

        var on_focus = function(event)
        {
            // trap focus in menu
            if (event.target !== header[0] && !jQuery.contains(header[0], event.target))
            {
                header.find('a').first().focus();

                return;
            }
        };

        var on_keydown = function(event)
        {
            // close on esc key
            if (event.which === 27)
            {
                close_navigations();
            }
        };

        var on_page_click = function()
        {
            menus.trigger('navigationitem:closeall');
        };

        var reset_scroll = function()
        {
            menubox.scrollTop(0);
        };

        page.on('navigation:toggle', function(event, target, open)
        {
            if (!target)
            {
                return;
            }

            if (typeof open == 'undefined')
            {
                open = !header.is('.' + target + open_suffix);
            }

            header.toggleClass(target + open_suffix, open);

            jQuery('html').toggleClass('scroll-disabled', open);

            page.off('focusin', on_focus);
            page.off('keydown', on_keydown);

            if (open)
            {
                page.on('focusin', on_focus);
                page.on('keydown', on_keydown);

                reset_scroll();
            }
            else
            {
                menus.trigger('navigationitem:closeall');
            }
        });

        page.on('navigation:open', function(event, target)
        {
            page.trigger('navigation:toggle', [ target, true ]);
        });

        page.on('navigation:close', function(event, target)
        {
            page.trigger('navigation:toggle', [ target, false ]);
        });

        toggles.on('click', function(event)
        {
            page.trigger('navigation:toggle', jQuery(this).data('target'));
        });


        // toggle submenu

        menus.on('navigationitem:toggle', '> li', function(event, open)
        {
            var item = jQuery(event.target);
            var layout = page.data('layout');

            if (typeof open == 'undefined')
            {
                open = !item.is('.open');
            }

            item.toggleClass('open', open);
            header.toggleClass('submenu' + open_suffix, open);

            if (layout == 'compact')
            {
                reset_scroll();
            }
            else
            {
                item.toggleClass('extreme', open ? !is_entirely_visible(item.children('ul')) : false);

                page[open ? 'on' : 'off']('click', on_page_click);

                if (!is_any_navigation_open())
                {
                    page[open ? 'on' : 'off']('keydown', on_keydown);
                }
            }
        });

        menus.on('navigationitem:open', '> li', function(event)
        {
            jQuery(event.target).trigger('navigationitem:toggle', true);
        });

        menus.on('navigationitem:close', '> li', function(event)
        {
            jQuery(event.target).trigger('navigationitem:toggle', false);
        });

        menus.on('navigationitem:closeall', function(event)
        {
            jQuery(event.target).find('.has-children.open').trigger('navigationitem:close');
        });

        menus.on('click', '.has-children > a', function(event)
        {
            var item = jQuery(this).closest('li');
            var layout = page.data('layout');

            if (layout == 'compact')
            {
                item.trigger('navigationitem:open');
            }
            else
            {
                if (item.closest('nav').is('.modes'))
                {
                    return true;
                }

                menus.find('.has-children.open').not(item).trigger('navigationitem:close');
                item.trigger('navigationitem:toggle');
            }

            return false;
        });

        var back_buttons = menus.find('button.back');
        back_buttons.on('click', function(eevent)
        {
            jQuery(this).closest('.has-children.open').trigger('navigationitem:close');
        });


        jQuery(window).on('resizehorizontal', close_navigations);
        page.on('layoutchange', close_navigations);

        header.find('nav.main').on('click', '.has-children', function(event)
        {
            event.stopPropagation();
        });

    });

}());
