//= require shared/application_form.js
//= require shared/expandable.js

jQuery(function()
{
    var body = jQuery('body');
    var usage_warnings = body.find('.usage-warning');
    var button_continue = body.find('.js-continue');
    if (body.length < 1) {
        return;
    }

    body.on('change', '.js-usage-purpose', function (e) {
        if (e.currentTarget != e.target) {
            return;
        }

        var selected = jQuery(e.target).find('option:selected');
        if (should_show_warning(selected)) {
            usage_warnings.addClass('is-shown');
            button_continue.hide();
            return;
        }

        if (should_hide_warning(selected)) {
            usage_warnings.removeClass('is-shown');
            button_continue.show();
        }
    });

    var should_show_warning = function(selected)
    {
        return selected.hasClass('is-high-risk') && !usage_warnings.hasClass('is-shown');
    }

    var should_hide_warning = function(selected)
    {
        return !selected.hasClass('is-high-risk') && usage_warnings.hasClass('is-shown');
    }
});
