(function()
{
    'use strict';

    var page = jQuery(document);

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var inputs = block.find('.field.switch input');

        inputs.on('change', function()
        {
            var input = jQuery(this);
            var value = input.val();

            var fieldsets = input.closest('.field').parent().find('[data-switch-relation]');

            fieldsets.removeClass('selected');
            fieldsets.filter('[data-switch-relation="' + value + '"]').addClass('selected');
        });

        inputs.filter(':checked').trigger('change');
    });

    // ordered list nested list item manual numbering
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var subSurveys = block.find('ol.survey ol.survey');

        subSurveys.each(function()
        {
            var subSurvey = jQuery(this);
            var parentItemValue = subSurvey.closest('li').attr('value');

            if (!parentItemValue)
            {
                return;
            }

            subSurvey.children('li').attr('data-parent-value', parentItemValue);
        });
    });

}());
