//= require shared/personal.js
//= require vendor/accessible-tabs/jQuery.tabs.js

(function()
{
    'use strict';

    var page = jQuery(document);

    // switch client data type tabs
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var types = block.find('.data-types');

        types.tabs();
    });

    // make form submit button sticky inside of panel
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var panel = block.find('.panel').first();

        if (!panel.length)
        {
            return;
        }

        var panelOffset, panelPadding;
        var minPanelTop, maxPanelBottom;
        var viewportWidth, viewportHeight;

        var button = panel.find('.action .button');

        var readCoordinates = function()
        {
            panelOffset = panel.offset();
            panelPadding = {
                top: parseInt(panel.css('padding-top')),
                right: parseInt(panel.css('padding-right')),
                bottom: parseInt(panel.css('padding-bottom')),
                left: parseInt(panel.css('padding-left')),
            };

            minPanelTop    = panelOffset.top + panelPadding.top + panelPadding.bottom + button.outerHeight();
            maxPanelBottom = panelOffset.top + panel.outerHeight();

            viewportWidth  = jQuery(window).width();
            viewportHeight = jQuery(window).height();
        };

        var stick = function()
        {
            var viewportBottom = jQuery(window).scrollTop() + viewportHeight;

            var isWithinBounds = (
                (viewportBottom >= minPanelTop)
                &&
                (viewportBottom < maxPanelBottom)
            );

            var buttonRight = viewportWidth - (panelOffset.left + panel.outerWidth()) + panelPadding.right;

            button.toggleClass('sticky', isWithinBounds);
            button.css('right', isWithinBounds ? buttonRight : '');
        };

        var initialize = function()
        {
            jQuery(window).off('scroll', stick);

            if (/^compact$/.test(page.data('layout')))
            {
                button.removeClass('sticky').css('right', '');

                return;
            }

            readCoordinates();
            stick();

            jQuery(window).on('scroll', stick);
        };

        page.on('resizeend', initialize);

        initialize();
    });

    // handle settings form submission 
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var form   = block.find('form.settings');
        var button = form.find('.panel .button[type="submit"]');

        if (!button.length)
        {
            return;
        }

        var successCallback = function()
        {
            button.trigger('button:success');
        };

        button.on('click', function(event)
        {
            event.preventDefault();

            page.trigger('dialog:open', { source: '.dialog.warning' });
            // page.trigger('dialog:open', { source: '.dialog.failure' });

            // form submission handler goes here.
            // `successCallback` function should be called after successful request.

            successCallback();
        });
    });

    // toggle data priority checkboxes
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var inputs = block.find('.field.priority input');

        if (inputs.length < 2)
        {
            return;
        }

        inputs.on('click', function(event)
        {
            var input = jQuery(this);

            this.checked ? inputs.not(input).prop('checked', false) : event.preventDefault();
        });
    });

}());
