(function()
{
    'use strict';

    var page = jQuery(document);

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var layout = page.data('layout');
        var large_layout = layout.match(/^(medium|full)$/);
        var is_touch_device = jQuery('html').is('.touch-device');

        if (is_touch_device && !large_layout && is_native_input_type_supported('time'))
        {
            return;
        }

        var maskOptions = {
            mask: 'H{:}`i',
            groups: {
                H: new IMask.MaskedPattern.Group.Range([0, 23]),
                i: new IMask.MaskedPattern.Group.Range([0, 59])
            }
        };

        block.find('input[type="time"]').each(function()
        {
            var input = jQuery(this);

            input.attr({
                type: 'text',
                placeholder: '––:––',
            });

            new IMask(input[0], maskOptions);
        });
    });

}());
