(function()
{
    'use strict';
    if (!('matchMedia' in window))
    {
        return;
    }

    var page = jQuery(document);

    page.on('mediachange', function( e, _media )
    {
        //console.log('media changed to ' + media);
    });

    var printMatcher = window.matchMedia('print');

    if (!printMatcher || !printMatcher.addListener)
    {
        return;
    }

    printMatcher.addListener(function(matcher)
    {
        var media = (matcher.matches) ? 'print' : 'non-print';
        page.data('media', media);
        page.trigger('mediachange', media);
    });

}());
