(function()
{
    'use strict';

    var page = jQuery(document);


    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        if (!block.is(page))
        {
            return;
        }

        var header = block.find('header.sc-c782f409-0, header.youQG, body > header').first();
        if (!header.length) {
            header = block.find('header').first();
        }

        var headerWrapper = header.closest('.sc-1daf48e2-0, .eAIGPl');
        if (!headerWrapper.length) {
            headerWrapper = header;
        }

        var toggles = headerWrapper.find('button.toggle');

        var open_suffix = '-open';

        var navigations = toggles.map(function(index, element)
        {
            return jQuery(element).data('target');
        })

        var close_navigations = function()
        {
            jQuery.each(navigations, function(index, value)
            {
                if (!headerWrapper.is('.' + value + open_suffix))
                {
                    return;
                }

                page.trigger('navigation:close', value);
            });

            jQuery('html').removeClass('scroll-disabled');
        };

        var on_focus = function(event)
        {
            // trap focus in menu
            if (event.target !== header[0] && !jQuery.contains(header[0], event.target))
            {
                header.find('a').first().focus();

                return;
            }
        };

        var on_keydown = function(event)
        {
            // close on esc key
            if (event.which === 27)
            {
                close_navigations();
            }
        };

        page.on('navigation:toggle', function(event, target, open)
        {
            if (!target)
            {
                return;
            }

            if (typeof open == 'undefined')
            {
                open = !headerWrapper.is('.' + target + open_suffix);
            }

            headerWrapper.toggleClass(target + open_suffix, open);

            jQuery('html').toggleClass('scroll-disabled', open);

            page.off('focusin', on_focus);
            page.off('keydown', on_keydown);

            if (open)
            {
                page.on('focusin', on_focus);
                page.on('keydown', on_keydown);
            }
            else
            {
                //menus.trigger('navigationitem:closeall');
            }
        });

        page.on('navigation:open', function(event, target)
        {
            page.trigger('navigation:toggle', [ target, true ]);
        });

        page.on('navigation:close', function(event, target)
        {
            page.trigger('navigation:toggle', [ target, false ]);
        });

        toggles.on('click', function(event)
        {
            page.trigger('navigation:toggle', jQuery(this).data('target'));
        });

        var mobileMenuButton = headerWrapper.find('button.ibDDNK, button.sc-db3e0b97-4');
        mobileMenuButton.on('click', function(event)
        {
            var target = jQuery(this).data('target') || 'menu';
            var mobileHeader = jQuery('header.sc-c782f409-0, header.youQG').first();
            var desktopNav = jQuery('nav.sc-526c4351-0, nav.houivD').first();
            var isOpening = !headerWrapper.hasClass(target + open_suffix);

            if (isOpening)
            {
                if (desktopNav.length && mobileHeader.length)
                {
                    mobileHeader.find('[data-mobile-menu]').show();
                }
            }
            else
            {
                mobileHeader.find('[data-mobile-menu]').hide();
            }

            page.trigger('navigation:toggle', target);
        });

        jQuery(document).on('click', '.sc-bf8c2200-2', function(event)
        {
            var button = jQuery(this);
            var parentNextSibling = button.parent().next();
            var arrow = button.find('.sc-bf8c2200-3');


            if (parentNextSibling.length)
            {
                if (parentNextSibling.hasClass('gXLPCY'))
                {
                    button.attr('aria-expanded', 'true');
                    parentNextSibling.removeClass('gXLPCY').addClass('dDHXBw');
                }
                else if (parentNextSibling.hasClass('dDHXBw'))
                {
                    button.attr('aria-expanded', 'false');
                    parentNextSibling.removeClass('dDHXBw').addClass('gXLPCY');
                }
            }

            if (arrow.length) {
                if (arrow.hasClass('gZJja-D')) {
                    arrow.removeClass('gZJja-D').addClass('eDhJnt');
                } else if (arrow.hasClass('eDhJnt')) {
                    arrow.removeClass('eDhJnt').addClass('gZJja-D');
                }
            }
        });

        jQuery(document).on('click', '.sc-2e25a20a-5', function(event)
        {
            var button = jQuery(this);
            var isCurrentlyExpanded = button.hasClass('dNLvcL');

            jQuery('.sc-2e25a20a-5').not(button).each(function()
            {
                var otherButton = jQuery(this);
                if (otherButton.hasClass('dNLvcL'))
                {
                    otherButton.removeClass('dNLvcL').addClass('hnSMzU');
                }

                var otherIcon = otherButton.find('.sc-2e25a20a-7');
                if (otherIcon.length && otherIcon.hasClass('DIRFl'))
                {
                    otherIcon.removeClass('DIRFl').addClass('cBTFlL');
                }
            });

            if (button.hasClass('hnSMzU'))
            {
                button.removeClass('hnSMzU').addClass('dNLvcL');
            }
            else if (button.hasClass('dNLvcL'))
            {
                button.removeClass('dNLvcL').addClass('hnSMzU');
            }

            var iconElement = button.find('.sc-2e25a20a-7');
            if (iconElement.length)
            {
                if (iconElement.hasClass('cBTFlL'))
                {
                    iconElement.removeClass('cBTFlL').addClass('DIRFl');
                }
                else if (iconElement.hasClass('DIRFl'))
                {
                    iconElement.removeClass('DIRFl').addClass('cBTFlL');
                }
            }
        });


        // close submenus when clicking outside
        jQuery(document).on('click', function(event)
        {
            if (!jQuery(event.target).closest('nav[aria-label="Main menu"]').length)
            {
                jQuery('nav[aria-label="Main menu"] button[aria-expanded="true"]').each(function()
                {
                    var button = jQuery(this);
                    var submenu = button.siblings('div').first();

                    button.attr('aria-expanded', 'false');
                    submenu.css('display', 'none');
                });
            }
        });

        // mobile menu submenu toggle
        jQuery(document).on('click', '[data-mobile-menu] nav[aria-label="Main menu"] > div > button', function(event)
        {
            var button = jQuery(this);
            var tabindexContainer = button.siblings('div[tabindex]').first();

            if (!tabindexContainer.length)
            {
                return;
            }

            // close all other open submenus
            jQuery('[data-mobile-menu] nav[aria-label="Main menu"] > div > div[tabindex].cnYLET').not(tabindexContainer).each(function()
            {
                jQuery(this).removeClass('cnYLET').addClass('cnVtKi');
            });

            // toggle current submenu
            if (tabindexContainer.hasClass('cnYLET'))
            {
                tabindexContainer.removeClass('cnYLET').addClass('cnVtKi');
                jQuery('html').removeClass('scroll-disabled');
            }
            else
            {
                tabindexContainer.removeClass('cnVtKi').addClass('cnYLET');
                jQuery('html').addClass('scroll-disabled');
            }

            event.stopPropagation();
        });

        // close mobile submenus when clicking outside
        jQuery(document).on('click', function(event)
        {
            if (!jQuery(event.target).closest('[data-mobile-menu] nav[aria-label="Main menu"] > div > div[tabindex]').length)
            {
                jQuery('[data-mobile-menu] nav[aria-label="Main menu"] > div > div[tabindex].cnYLET').each(function()
                {
                    jQuery(this).removeClass('cnYLET').addClass('cnVtKi');
                });
                jQuery('html').removeClass('scroll-disabled');
            }
        });

        // close submenu when clicking on sc-blHHSb element
        jQuery(document).on('click', '.sc-blHHSb', function(event)
        {
            jQuery('[data-mobile-menu] nav[aria-label="Main menu"] > div > div[tabindex].cnYLET').each(function()
            {
                jQuery(this).removeClass('cnYLET').addClass('cnVtKi');
            });
            jQuery('html').removeClass('scroll-disabled');

            jQuery('nav[aria-label="Main menu"] button[aria-expanded="true"]').each(function()
            {
                var button = jQuery(this);
                var submenu = button.siblings('div').first();

                button.attr('aria-expanded', 'false');
                submenu.css('display', 'none');
            });
        });


        jQuery(window).on('resizehorizontal', close_navigations);
        page.on('layoutchange', close_navigations);


        var localeButtons = document.querySelectorAll('[data-locale-toggle]');

        localeButtons.forEach(function(localeButton) {
            var localePopup = localeButton.querySelector('[data-locale-popup]');

            if (!localePopup) {
                localePopup = localeButton.parentElement.querySelector('[data-locale-popup]');
            }

            if (localePopup) {
                localeButton.addEventListener('click', function (event) {
                    if (event.target.tagName === 'A' || event.target.closest('a')) {
                        return;
                    }
                    event.preventDefault();
                    event.stopPropagation();

                    var isExpanded = localeButton.getAttribute('aria-expanded') === 'true';

                    if (isExpanded) {
                        localeButton.setAttribute('aria-expanded', 'false');
                        localePopup.style.display = 'none';
                    } else {
                        localeButton.setAttribute('aria-expanded', 'true');
                        localePopup.style.display = 'flex';
                    }
                });

                document.addEventListener('click', function (event) {
                    if (!localeButton.contains(event.target) && !localePopup.contains(event.target)) {
                        localeButton.setAttribute('aria-expanded', 'false');
                        localePopup.style.display = 'none';
                    }
                });
            }
        });

        // Desktop menu dropdown toggle
        jQuery(document).on('click', '.sc-526c4351-3', function(event) {
            event.preventDefault();
            event.stopPropagation();

            var button = jQuery(this);
            var dropdown = button.closest('.sc-hsfCcR').find('.sc-81b0ec4f-0').first();
            var arrow = button.find('.sc-526c4351-5').first();
            var isCurrentlyOpen = button.hasClass('bzkQJq');

            // Close all other open menu items
            jQuery('.sc-526c4351-3.bzkQJq').not(button).each(function() {
                var otherButton = jQuery(this);
                var otherDropdown = otherButton.closest('.sc-hsfCcR').find('.sc-81b0ec4f-0').first();
                var otherArrow = otherButton.find('.sc-526c4351-5').first();

                // Revert button classes
                otherButton.removeClass('bzkQJq').addClass('dMVDt');
                otherButton.attr('aria-expanded', 'false');

                // Revert dropdown classes
                if (otherDropdown.length) {
                    otherDropdown.removeClass('fFBfKx').addClass('hKxGJy');
                }

                // Revert arrow classes
                if (otherArrow.length) {
                    otherArrow.removeClass('fiQFdz').addClass('hQbahl');
                }
            });

            if (dropdown.length) {
                // Toggle current button classes
                if (isCurrentlyOpen) {
                    button.removeClass('bzkQJq').addClass('dMVDt');
                    button.attr('aria-expanded', 'false');
                } else {
                    button.removeClass('dMVDt').addClass('bzkQJq');
                    button.attr('aria-expanded', 'true');
                }

                // Toggle current dropdown classes
                if (isCurrentlyOpen) {
                    dropdown.removeClass('fFBfKx').addClass('hKxGJy');
                } else {
                    dropdown.removeClass('hKxGJy').addClass('fFBfKx');
                }

                // Toggle current arrow classes
                if (arrow.length) {
                    if (isCurrentlyOpen) {
                        arrow.removeClass('fiQFdz').addClass('hQbahl');
                    } else {
                        arrow.removeClass('hQbahl').addClass('fiQFdz');
                    }
                }
            }
        });

        // Close all desktop menu dropdowns when clicking outside
        jQuery(document).on('click', function(event) {
            if (!jQuery(event.target).closest('.sc-526c4351-0, .houivD').length) {
                jQuery('.sc-526c4351-3.bzkQJq').each(function() {
                    var button = jQuery(this);
                    var dropdown = button.closest('.sc-hsfCcR').find('.sc-81b0ec4f-0').first();
                    var arrow = button.find('.sc-526c4351-5').first();

                    // Revert button classes
                    button.removeClass('bzkQJq').addClass('dMVDt');
                    button.attr('aria-expanded', 'false');

                    // Revert dropdown classes
                    if (dropdown.length) {
                        dropdown.removeClass('fFBfKx').addClass('hKxGJy');
                    }

                    // Revert arrow classes
                    if (arrow.length) {
                        arrow.removeClass('fiQFdz').addClass('hQbahl');
                    }
                });
            }
        });

    });

}());
