//= require vendor/flipclock/flipclock.js

var Countdown = (function() {
    'use strict';

    function Countdown(targets) {
        this.language = document.querySelector('html').getAttribute('lang') || 'lv';
        this.flipClock = null;

        this.createClock(targets);
        this.$seconds = jQuery('.flip-clock-divider.seconds .flip-clock-label');
        this.$minutes = jQuery('.flip-clock-divider.minutes .flip-clock-label');
        this.$hours = jQuery('.flip-clock-divider.hours .flip-clock-label');
        this.$days = jQuery('.flip-clock-divider.days .flip-clock-label');

        this.translations = {
            lv: {
                secondSingular: 'Sekunde',
                secondPlural: 'Sekundes',
                minuteSingular: 'Minūte',
                minutePlural: 'Minūtes',
                hourSingular: 'Stunda',
                hourPlural: 'Stundas',
                daySingular: 'Diena',
                dayPlural: 'Dienas',
            },
            ru: {
                secondSingular: 'Секунда',
                secondPlural: 'Секунды',
                secondPluralAlt: 'Секунд',
                minuteSingular: 'Минута',
                minutePlural: 'Минуты',
                minutePluralAlt: 'Минут',
                hourSingular: 'Час',
                hourPlural: 'Часа',
                hourPluralAlt: 'Часов',
                daySingular: 'День',
                dayPlural: 'Дня',
                dayPluralAlt: 'Дней',
            },
        };
    }

    Countdown.prototype.createClock = function(targets) {
        var currentDate = new Date();
        var futureDate = new Date(currentDate.getFullYear() + 1, 0, 1);
        var diff = futureDate.getTime() / 1000 - currentDate.getTime() / 1000;

        this.flipClock = targets.FlipClock(diff, {
            clockFace: 'DailyCounter',
            countdown: true,
            language: this.language,
            callbacks: {
                interval: this.tick.bind(this),
            },
        });
    };

    Countdown.prototype.tick = function() {
        if (this.flipClock) {
            var time = this.flipClock.face.factory.time;

            var seconds = time.getSeconds(true),
                minutes = time.getMinutes(true),
                hours = time.getHours(true),
                days = time.getDays(true);

            this.$seconds.text(this.getAlias('second', seconds));
            this.$minutes.text(this.getAlias('minute', minutes));
            this.$hours.text(this.getAlias('hour', hours));
            this.$days.text(this.getAlias('day', days));
        }
    };

    Countdown.prototype.getAlias = function(unit, value) {
        var singularKey = unit + 'Singular';
        var pluralKey = unit + 'Plural';
        var pluralAltKey = unit + 'PluralAlt';
        var translation;
        var lastDigit = parseInt(value.toString().slice(-1));

        if (this.language === 'lv') {
            switch (true) {
                case (value === 1):
                    translation = this.translations[this.language][singularKey];
                    break;
                case (value === 11):
                    translation = this.translations[this.language][pluralKey];
                    break;
                case (lastDigit === 1):
                    translation = this.translations[this.language][singularKey];
                    break;
                default:
                    translation = this.translations[this.language][pluralKey];
                    break;
            }
        } else if (this.language === 'ru') {
            switch (true) {
                case (value === 1):
                    translation = this.translations[this.language][singularKey];
                    break;
                case (value >= 2 && value <= 4):
                    translation = this.translations[this.language][pluralKey];
                    break;
                case (value === 11):
                    translation = this.translations[this.language][pluralAltKey];
                    break;
                case (lastDigit === 1):
                    translation = this.translations[this.language][singularKey];
                    break;
                case (lastDigit >= 2 &&
                    lastDigit <= 4):
                    translation = this.translations[this.language][pluralKey];
                    break;
                default:
                    translation = this.translations[this.language][pluralAltKey];
                    break;
            }
        }

        return translation;
    };

    return Countdown;

}());
