const gulpRoot = ".";
const publicAssetRoot  = "../public/assets";

const assetOrigins = ["base", "info"];

const assetOriginFolderGlob = (assetOrigins.length > 1) ? "{" + assetOrigins.join(",") + "}" : assetOrigins[0];
const sourceAssetRootGlob = gulpRoot + "/" + assetOriginFolderGlob + "/assets";

const config = {
    assetOrigins: assetOrigins,
    publicAssetRoot: publicAssetRoot,

    images:
    {
        // expected results: (same for fonts)

        // base/assets/images/dummy.png --> assets/images/dummy.png
        // info/assets/images/dummy.png --> assets/images/dummy.png (avoid conflicts, otherwise something will be overwritten)

        // scss source:
        // background-image: url("images/dummy.png")
        // css result in dev:
        // background-image: url("/assets/images/dummy.png")
        // css result after build:
        // background-image: url("/assets/images/dummy-abc1234567.png")

        sourcePath:     sourceAssetRootGlob + "/images/**/*.{png,svg}",
        watchablePath:  sourceAssetRootGlob + "/images/**/*.{png,svg}"
    },

    fonts:
    {
        // see images key above for description

        sourcePath:     sourceAssetRootGlob + "/fonts/**/*.{ttf,woff,woff2}",
        watchablePath:  sourceAssetRootGlob + "/fonts/**/*.{ttf,woff,woff2}"
    },

    sass:
    {
        compilablePaths: [
            sourceAssetRootGlob + "/stylesheets/application.{scss,css}",
            sourceAssetRootGlob + "/stylesheets/controllers/**/*.{scss,css}",
        ],
        urlPrefix: '/assets/', // changes url("images/foo.png"); to url("/assets/images/foo.png"); in all styles
        watchablePath: sourceAssetRootGlob + "/stylesheets/**/*.{scss,css}",
    },

    js:
    {
        compilablePaths: [
            sourceAssetRootGlob + "/javascripts/application.js",
            sourceAssetRootGlob + "/javascripts/controllers/**/*.js",
        ],
        watchablePath: sourceAssetRootGlob + "/javascripts/**/*.js",

        // paths for 'require' (javascript folders in all origins + node_modules)
        includePaths: assetOrigins.map(origin => gulpRoot + "/" + origin + "/assets/javascripts")
        .concat([ gulpRoot + "/node_modules" ])
    },

    rev:
    {
        versionablePaths: publicAssetRoot + "/{stylesheets,javascripts,images,fonts}/**/*.{css,js,png,svg,ttf,woff,woff2}",
        destinationPath:  publicAssetRoot
    },

    clean:
    {
        cleanablePaths: [
            publicAssetRoot + '/stylesheets',
            publicAssetRoot + '/javascripts',
            publicAssetRoot + '/images',
            publicAssetRoot + '/fonts',
            publicAssetRoot + '/rev-manifest.json',
            publicAssetRoot + '/../base-assets-version.txt'
        ]
    }
};

module.exports = config;
