const gulp   = require('gulp');
const config = require('../config');

const fs   = require('fs');
const gzip = require('gulp-gzip');
const rev  = require('gulp-rev');

gulp.task('gzip', function()
{
    // gzips all public versioned assets

    const manifestPath = config.publicAssetRoot + '/rev-manifest.json';
    const manifest = JSON.parse(fs.readFileSync(manifestPath).toString());

    var gzippablePaths = [];
    Object.keys(manifest).forEach(function(key, index)
    {
        gzippablePaths.push( config.publicAssetRoot + "/" + manifest[key] );
    });

    return gulp.src(gzippablePaths, { base: config.publicAssetRoot })
    .pipe(gzip())
    .pipe(gulp.dest(config.publicAssetRoot));
});
