const gulp   = require('gulp');
const config = require('../config');

const autoPrefixer    = require('gulp-autoprefixer');
const originCombiner  = require('../utilities/originCombiner');
const sass            = require('gulp-sass')(require('node-sass'));
const urlAdjuster     = require('gulp-css-url-adjuster');
const gulpIf          = require('gulp-if');
const cleanCss        = require('gulp-clean-css');

gulp.task('sass', function()
{
    return gulp.src(config.sass.compilablePaths)
    .pipe(sass({}))
    .pipe(autoPrefixer({ browsers: [
        '> 1%',
        'last 2 versions',
        'IE >= 9',
        'Firefox >= 25',
        'Android >= 4.2',
        'iOS >= 8.1'
    ] }))
    .pipe(originCombiner(config.assetOrigins))
    .pipe(urlAdjuster({ prependRelative: config.sass.urlPrefix }))
    .pipe(gulpIf(gulp.performingBuild, cleanCss()))
    .pipe(gulp.dest(config.publicAssetRoot));
});
