//= require shared/map_static.js

(function()
{
    'use strict';

    var page = jQuery(document);

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var input = block.find('.field.search input');
        var results = block.find('ul.resultbox');

        if (!input.length)
        {
            return;
        }

        input.on('input', function()
        {
            jQuery(this).trigger('control:valuecheck');
        });

        var clearButton = input.closest('.field').find('button.clear');
        clearButton.on('click', function()
        {
            input
                .val('')
                .focus()
                .trigger('control:valuecheck');

            input.closest('.control').attr('aria-expanded', 'false');
            results.prop('hidden', true);
        });

        input.trigger('input');
    });

}());
