function isLeftmostControl(control) {
    var previousControl = control.prev();

    if (
        !previousControl.length
        ||
        previousControl.position().top < control.position().top
    ) {
        return true;
    }

    return false;
}

function isRightmostControl(control) {
    var nextControl = control.next();

    if (
        !nextControl.length
        ||
        nextControl.position().top > control.position().top
    ) {
        return true;
    }

    return false;
}

function roundCorners(radioControl) {
    var individualControls = jQuery(radioControl).find('span.option');

    individualControls.each(function (index, element) {
        var control = jQuery(element);

        if (isLeftmostControl(control)) {
            control.find('label').addClass('round-left-corners');
        }

        if (isRightmostControl(control)) {
            control.find('label').addClass('round-right-corners');
        }
    });
}

function roundAllRadioControls() {
    jQuery('.control.radio .option label').removeClass('round-left-corners round-right-corners');

    jQuery('.control.radio').each(function(index, radioControl) {
        roundCorners(radioControl);
    });
}

(function()
{
    'use strict';
    var page = jQuery(document);

    roundAllRadioControls();

    page.on('contentloaded', roundAllRadioControls);

    jQuery(window).resize(roundAllRadioControls);
}());
