//= require shared/application_form.js
//= require shared/field_trigger.js

(function()
{
    'use strict';

    var page = jQuery(document);

    // allow extras radio deselect
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var radios = block.find('.js-optional-radio');

        if (!radios.length)
        {
            return;
        }

        var removePreviousSelects = function()
        {
            radios.removeClass('selected');
            radios.prop('checked', false);
        };

        radios.on('click', function(event)
        {
            var radio = jQuery(event.currentTarget);
            var wasSelected = radio.hasClass('selected');

            removePreviousSelects();

            if (!wasSelected) {
                radio.prop('checked', true);
                radio.addClass('selected');
            }
        });
    });
}());
