//= require shared/personal.js

(function()
{
    'use strict';

    var page = jQuery(document);

    // attach form submission handler
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var form   = block.find('form.settings');
        var button = form.find('.action .button[type="submit"]');

        if (!button.length)
        {
            return;
        }

        var successCallback = function()
        {
            button.trigger('button:success');
        };

        button.on('click', function(event)
        {
            event.preventDefault();

            // form submission handler goes here.
            // `successCallback` function should be called after successful request.

            successCallback();
        });
    });

}());
