(function()
{
    'use strict';

    var page = jQuery(document);

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var elements = block.find('.expandable-text');
        var character_count = 150;

        elements.each(function()
        {
            var control = jQuery(this);
            var text = control.text();

            if (text.length < character_count)
            {
                return;
            }

            var summary = text.slice(0, character_count);
            var remaining = text.slice(character_count, text.length);

            var text_more = control.attr('data-text-more') || 'More';
            var text_less = control.attr('data-text-less') || 'Less';

            control.html(
                summary + '<span>&hellip;&nbsp;</span><a href="#" class="more">' + text_more + '</a><span style="display: none;">' +
                remaining + ' <a href="#" class="less">' + text_less + '</a></span>'
            );
        });

        jQuery('a.more', elements).click(function(event)
        {
            event.preventDefault();

            jQuery(this).hide().prev().hide();
            jQuery(this).next().show();
        });

        jQuery('a.less', elements).click(function(event)
        {
            event.preventDefault();

            jQuery(this).parent().hide().prev().show().prev().show();
        });
    });

}());
