UC_UI = undefined;

(function()
{
    'use strict';

    var page = jQuery(document);
    var map = page.find('.content.map > .google-map');
    var mapsUsercentricsId = map.data('usercentricsId');
    var loader = map.find('.loader-box');
    var mapStatic = map.find('.map-static');

    var displayMap = function ()
    {
        // mostly for ergo-front project, to be able to test static map showing up
        if (typeof UC_UI == 'undefined') {
            loader.hide();
            mapStatic.show();
        }

        var hasGoogleMapsConsent = UC_UI.getServicesBaseInfo()
            .find(isGoogleMapsService)
            .consent
            .status;

        if (hasGoogleMapsConsent) {
            return; // Google Maps script should have converted form plain/text to javascript/text and executed
        }

        loader.hide();
        mapStatic.show(); // user does not have google maps consent, display static map
    }

    var isGoogleMapsService = function (service)
    {
        return service.id === mapsUsercentricsId;
    }

    var listenForUserConsents = function ()
    {
        if (!UC_UI || !UC_UI.isInitialized()) {
            window.addEventListener('UC_UI_INITIALIZED', displayMap);
            return;
        }

        displayMap();
    }

    page.on('contentloaded', function(event)
    {
        listenForUserConsents();

        var mapDialog = mapStatic.find('.map-static__dialog');
        var cookieConfigurationButton = mapStatic.find('.js-open-cookie-configuration');
        var mapStaticDialogCloseButton = mapStatic.find('.js-map-static-dialog-close');

        cookieConfigurationButton.on('click', function()
        {
            UC_UI.showSecondLayer();
        });

        mapStaticDialogCloseButton.on('click', function()
        {
            mapDialog.hide();
        });
    });

}());
