//= require shared/expandable.js
//= require shared/expandable_text.js

(function()
{
    'use strict';

    var page = jQuery(document);

    page.on('layoutchange', function()
    {
        page.find('.expandable').trigger('collapse');
    });

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        block.find('.field[data-trigger]').each(function(index, field)
        {
            var target = jQuery(field);
            var trigger_name = target.attr('data-trigger');
            var inputs = target.find('input');
            var fields = block.find('[data-trigger-name=' + trigger_name + ']');

            if (!inputs.length || !fields.length)
            {
                return;
            }

            var changeValue = function()
            {
                fields.removeClass('selected');

                var value = inputs.filter(':checked').val() || 0;

                fields.find('input:checked').prop('checked', false).change();
                fields.filter('[data-trigger-value="' + value + '"]').addClass('selected');
                fields.filter('[data-trigger-value="' + value + '"]').find('input[type="radio"]').first().trigger('click');
                roundAllRadioControls();
            };

            inputs.on('change', changeValue);

            changeValue();
        });
    });

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var risk_group_dialog = page.find('#risk-group-dialog-standard, #risk-group-dialog-individual');

        page.find('.risk-group > .row > .column.title .has-dialog').on('click', function()
        {
            var target = jQuery(this);
            var risk_group = target.closest('.risk-group')
            var details = risk_group.find('.details').clone().removeAttr('style').removeClass('expandable-content');

            risk_group_dialog.find('h1.title').html(target.text());

            if (details.length > 0)
            {
                risk_group_dialog.find('.details').replaceWith(details);
                risk_group_dialog.find('.has-dialog').each(function()
                {
                    var trigger = jQuery(this);

                    trigger.on('click', function()
                    {
                        page.data('triggerId', target.attr('id'));
                    });

                    trigger.trigger('dialog:attach');
                });
            }
            else
            {
                risk_group_dialog.find('.details').html("");
            }
        });
    });

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var button = block.find('.summary .button[type="submit"]');

        if (!button.length)
        {
            return;
        }

        button.on('click', function(event)
        {
            event.preventDefault();

            page.trigger('dialog:open', { source: '.dialog.price-change' });
        });
    });

    // fit price in container
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var prices = block.find('.column.amount .price');

        if (!prices.length)
        {
            return;
        }

        var decreasedFontSize;

        var fitPrice = function(price)
        {
            var priceContainerWidth = price.parent().width();
            var value = price.find('.integer');

            value.css('font-size', '');

            var initialFontSize = parseInt(value.css('font-size'), 10);
            var fontSize = initialFontSize;

            while (price.outerWidth() > priceContainerWidth)
            {
                value.css('font-size', --fontSize);
            }

            var isPriceFitted = initialFontSize > fontSize;

            if (
                isPriceFitted
                &&
                (!decreasedFontSize || decreasedFontSize > fontSize)
            )
            {
                decreasedFontSize = fontSize;
            }
        };

        var initialize = function()
        {
            decreasedFontSize = null;

            prices.each(function()
            {
                fitPrice(jQuery(this));
            });

            prices.find('.integer').css('font-size', decreasedFontSize);
        };

        page.on('resizeend', initialize);

        initialize();
    });

}());
