(function () {
    function debounce(func, wait) {
        var timeout;
        return function () {
            var context = this, args = arguments;
            clearTimeout(timeout);
            timeout = setTimeout(function () {
                func.apply(context, args);
            }, wait);
        };
    }

    function send() {
        window.parent.postMessage(JSON.stringify({
            action: 'EmbedChildUpdated',
            height: document.body.scrollHeight
        }), '*')
    }

    function init() {
        var resizeFrequency = 100;
        document.addEventListener('DOMContentLoaded', send);
        window.addEventListener('resize', debounce(send, resizeFrequency));
    }

    if (window.parent) {
        init();
    }
}());
