//= require vendor/baseliner/baseliner.js
/*global Baseliner*/

jQuery(function()
{
    'use strict';
    var page = jQuery(document);

    page.on('baselinerinit', function()
    {
        if (jQuery('#baseliner-trigger').length > 0)
        {
            return;
        }

        var button = jQuery('<button type="button" id="baseliner-trigger">Baseline grid</button>');
        button.css(
        {
            position: 'fixed',
            zIndex:   '9999',
            left:     '50%',
            marginLeft: '-40px',
            top:      0,
            backgroundColor: 'rgba( 0,0,0,0.5)',
            color:           '#fff',
            padding: '5px',
            fontSize: '12px',
            lineHeight: '18px',
            border: 'none',
            cursor: 'pointer'

        });

        button.on('click', function()
        {
            var baselinerBox = jQuery('#overlay-it');
            if (baselinerBox.length < 1)
            {
                window.baseliner = new Baseliner(
                {
                    'gridColor': [0, 0, 0],
                    'gridOpacity': 80,
                    'gridHeight': 10,
                    'gridOffset': 1
                });


                setTimeout( function()
                {
                    jQuery('#overlay-it input:last-child').trigger('change');
                }, 100);
            }
            else
            {
                var overlay = jQuery('#baseline-overlay');
                baselinerBox.remove();
                if (overlay.length > 0)
                {
                    overlay.add(overlay.prev()).remove();
                }
                window.baseliner = null;
            }

        });

        jQuery('body').append(button);
    });

    if (jQuery('html').data('env') == 'development')
    {
        page.trigger('baselinerinit');
    }
});
