(function()
{
    'use strict';

    var page = jQuery(document);

    // toggle client type fields
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var inputs    = block.find('.field.client-type input');
        var fieldsets = block.find('fieldset.client');

        if (!inputs.length || !fieldsets.length)
        {
            return;
        }

        var typeChange = function()
        {
            var value = inputs.filter(':checked').val();

            if (!value)
            {
                return;
            }

            fieldsets.removeClass('selected');
            fieldsets.filter('[data-type="' + value + '"]').addClass('selected');
        };

        inputs.on('change', function()
        {
            typeChange();
        });

        typeChange();
    });

    // toggle foreign national fields
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var input = block.find('.field.foreign-national input');
        var uncheckedStateField = block.find('.field.person-id');
        var checkedStateField   = block.find('.field.birth-date');

        if (!input.length)
        {
            return;
        }

        input.on('change', function(event)
        {
            var isChecked = this.checked;

            uncheckedStateField.toggleClass('selected', !isChecked);
            checkedStateField.toggleClass('selected', isChecked);
        });

        input.trigger('change');
    });

}());
