const gulp   = require('gulp');
const config = require('../config');
const rename = require("gulp-rename");

gulp.task("images", function()
{
    const origins = config.assetOrigins;
    const pathPattern = new RegExp( "^(" + origins.join("|") + ")\/assets\/");

    return gulp.src(config.images.sourcePath)
    .pipe(rename(function(path)
    {
        path.dirname = path.dirname.replace(pathPattern, '');
    }))
    .pipe(gulp.dest(config.publicAssetRoot));
});
