const gulp   = require("gulp");
const config = require('../config');

const include        = require("gulp-include");
const foreach        = require('gulp-foreach');
const originCombiner = require('../utilities/originCombiner');
const gulpIf         = require('gulp-if');
const uglify         = require('gulp-uglify');

gulp.task("js", function()
{
    return gulp.src(config.js.compilablePaths)
    .pipe(foreach(function(stream, file){
      return stream
        .pipe(include({
            extensions: "js",
            hardFail: true,
            includePaths: config.js.includePaths
        }))
        .pipe(originCombiner(config.assetOrigins))
        .pipe(gulpIf(gulp.performingBuild, uglify()));
    }))
    .pipe(gulp.dest(config.publicAssetRoot));
});
