(function()
{
    'use strict';

    var page = jQuery(document);

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var counter_inputs = block.find('.counter input');
        var button = jQuery("<button/>", { class: "button", type: "button" });

        var increment = button.clone().addClass('increment');
        increment.on('click', function() {
            var input = jQuery(this).siblings('input');
            var value = parseInt(input.val() || 0) + 1;

            input.val(value);
        });

        var decrement = button.clone().addClass('decrement');
        decrement.on('click', function() {
            var input = jQuery(this).siblings('input');
            var value = parseInt(input.val() || 0) - 1;

            if (value < 0)
            {
                value = 0;
            }

            input.val(value);
        });

        counter_inputs.closest('.control').append(increment, decrement);
    });

}());
