(function()
{
    'use strict';

    var page = jQuery(document);

    // check whether form control initial values have changed
    page.on('contentloaded', function(event)
    {
        var block    = jQuery(event.target);
        var form     = block.find('form.settings');
        var controls = form.find('input, select');

        if (!controls.length)
        {
            return;
        }

        var hasValueChanged = function(control)
        {
            return getControlValue(control) !== getControlInitialValue(control);
        };

        var toggleFormState = function()
        {
            var formChanged = false;

            controls.each(function()
            {
                formChanged = hasValueChanged(jQuery(this));

                return !formChanged;
            });

            form.toggleClass('changed', formChanged);
        };

        controls.on('input change', function(event)
        {
            toggleFormState();
        });

        toggleFormState();
    });

    page.on('button:success', '.button', function(event)
    {
        var button = jQuery(event.target);

        var buttonInitialText = button.text();
        var buttonSuccessText = button.data('successText');

        button
            .addClass('successful')
            .prop('disabled', true)
            .text(buttonSuccessText);

        var successTimeout = setTimeout(function()
        {
            button
                .removeClass('successful')
                .prop('disabled', false)
                .text(buttonInitialText);

        }, 3000);
    });

}());
