//= require vendor/no-ui-slider/nouislider.min.js

(function()
{
    'use strict';

    var page = jQuery(document);
    var birthDateInput = page.find('input[name="birth_date"]');

    page.on('contentloaded', function(event)
    {
        var toggleInsurancePeriod = page.find('.js-toggle-insurance-period');
        var toggleInsuranceApplication = page.find('.js-toggle-insurance-application')
        var calculator = jQuery('.calculator');

        toggleInsurancePeriod.on('click', function ()
        {
            calculator.removeClass('show-form');
            calculator.toggleClass('show-table');
        });

        toggleInsuranceApplication.on('click', function ()
        {
            calculator.removeClass('show-table');
            calculator.toggleClass('show-form');
        });
    });

    var createSlider = function (slider)
    {
        var amountField = jQuery('.js-amount[data-slider="' + slider.attr('id') + '"]');
        var inputField = jQuery('input[name="' + slider.attr('id') + '"]');
        var form = slider.closest('form');

        var settings =
            {
                start: slider.data('start'),
                step: slider.data('step'),
                connect: [true, false],
                decimals: 0,
                range: {
                    'min': slider.data('min'),
                    'max': slider.data('max')
                },
                format: {
                    to: function (value) {
                        return Math.round(value);
                    },
                    from: function (value) {
                        return value;
                    }
                },
            };

        noUiSlider.create(slider[0], settings);

        slider[0].noUiSlider.on('slide', function(values, handle)
        {
            amountField.text(values[handle]);
            inputField.val(values[handle]);

            setTimeout(function () {
                form.trigger('change');
            }, 500);
        });
    }

    jQuery('.js-range').each(function(i, element)
    {
        var slider = jQuery(element);
        createSlider(slider);
    });

    var getAge = function (dateString)
    {
        var today = new Date();
        var birthDate = new Date(dateString);
        var age = today.getFullYear() - birthDate.getFullYear();
        var m = today.getMonth() - birthDate.getMonth();
        if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
            age--;
        }
        return age;
    }

    page.on('contentloaded', function()
    {
        var termSlider = jQuery('.js-insurance-term');
        var termMaxLabel = jQuery('.js-max-term');
        var termInput = jQuery('input[name="insurance_term"]');
        var termLabel = jQuery('.js-amount[data-slider="insurance_term"]');

        var updateTermLabels = function (currentTerm, termMax)
        {
            termMaxLabel.text(termMax + ' ' + termSlider.data('labelMax'));
            termInput.val(currentTerm);
            termLabel.text(currentTerm);
        }

        var updateTermSlider = function (currentTerm, termMax)
        {
            termSlider[0].noUiSlider.destroy();

            termSlider.data('start', currentTerm);
            termSlider.data('max', termMax);

            createSlider(termSlider)
        }

        jQuery('.control.date').on('change', 'input', function (event) {
            var termMax = termSlider.data('maxAge') - getAge(birthDateInput.val());
            var currentTerm = termInput.val();

            if (currentTerm > termMax) {
                currentTerm = termMax;
            }

            updateTermLabels(currentTerm, termMax);
            updateTermSlider(currentTerm, termMax)
        });
    });
}());
