//= require jquery-ui/ui/widget.js
//= require vendor/file-upload/jquery.iframe-transport.js
//= require vendor/file-upload/jquery.fileupload.js
//= require vendor/file-upload/jquery.fileupload-process.js
//= require vendor/file-upload/jquery.fileupload-image.js
//= require vendor/file-upload/jquery.fileupload-validate.js
//= require vendor/file-upload/jquery.fileupload-ui.js

(function()
{
    'use strict';

    var page = jQuery(document);

    // attach edit and remove button handler
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var receipts = block.find('.panel.form .receipts');

        var onKeydown = function(event)
        {
            // cancel on esc key
            if (event.which === 27)
            {
                jQuery(event.target).closest('.field').find('button.cancel').click();
            }
        };

        receipts.on('click', 'button.remove', function(event)
        {
            var button = jQuery(this);
            var target = button.data('target');

            button.closest('.' + target).remove();
        });

        receipts.on('click', 'button.edit', function(event)
        {
            var button = jQuery(this);
            var field = button.closest('.field');
            var input = field.find('input, select, textarea').last();

            input.on('focus', function(event)
            {
                page.on('keydown', onKeydown);
            });

            input.on('blur', function(event)
            {
                page.off('keydown', onKeydown);
            });

            field.addClass('open');
            input.focus();
        });

        receipts.on('click', 'button.save', function(event)
        {
            var field = jQuery(this).closest('.field');
            var valueNode = field.find('.value').contents().first();
            var inputValue = escapeHtml(field.find('input').last().val());

            valueNode.replaceWith(inputValue);

            field.removeClass('open');
        });

        receipts.on('click', 'button.cancel', function(event)
        {
            var field = jQuery(this).closest('.field');
            var currentValue = jQuery.trim(field.find('.value').contents().first().text());
            var input = field.find('input').last();

            input.val(currentValue);

            field.removeClass('open');
        });
        
    });

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var receipts = block.find('.panel.form .receipts');

        if (!receipts.length)
        {
            return;
        }

        receipts.on('click', '.services button.add', function()
        {
            var button = jQuery(this);

            var serviceHtml = button.closest('.services').find('> template').html().trim();
            var service = jQuery(serviceHtml).insertBefore(button.closest('.action'));

            var idSuffix = '-' + Math.random().toString(16).slice(2);

            service.find('input, select').each(function()
            {
                var control = jQuery(this);
                var labels = jQuery(this).closest('.field').find('label');
                var uniqueId = control.attr('id') + idSuffix;

                control.attr('id', uniqueId);
                labels.attr('for', uniqueId);
            });

            service.find('input[type="number"]').each(function()
            {
                jQuery(this).trigger('number:attach');
            });
        });
    });

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var receipts = block.find('.panel.form .receipts');

        if (!receipts.length)
        {
            return;
        }

        var addButton = block.find('.summary > .action button.add');
        var receiptHtml = receipts.find('> template').html().trim();

        addButton.on('click', function()
        {
            var receipt = jQuery(receiptHtml).appendTo(receipts);
            var idSuffix = '-' + Math.random().toString(16).slice(2);

            receipt.find('input, select').each(function()
            {
                var control = jQuery(this);
                var labels = jQuery(this).closest('.field').find('label');
                var uniqueId = control.attr('id') + idSuffix;

                control.attr('id', uniqueId);
                labels.attr('for', uniqueId);
            });

            receipt.trigger('contentloaded');
        });
    });

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);
        var button = block.find('.wizard-action .button.proceed[type="submit"]');

        if (!button.length)
        {
            return;
        }

        button.on('click', function(event)
        {
            event.preventDefault();

            page.trigger('dialog:open', { source: '.dialog.institution' });
        });
    });

    // combobox text input basic behaviour
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var combobox = block.find('.field.institution');

        if (!combobox.length)
        {
            return;
        }

        combobox.on('input change', '.control input', function()
        {
            jQuery(this).trigger('control:valuecheck');
        });

        combobox.on('click', 'button.clear', function()
        {
            var button = jQuery(this);
            var control = button.closest('.control');
            var input = control.find('input');

            input
                .val('')
                .focus()
                .trigger('control:valuecheck');

            control.attr('aria-expanded', 'false');
            control.closest('.field').find('ul.resultbox').prop('hidden', true);
        });

        combobox.find('.control input').trigger('change');
    });

}());
