//= require shared/field_trigger.js

(function()
{
    'use strict';

    var page = jQuery(document);

    // select vehicle damaged parts
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var damages = block.find('.collision.vehicle .damages');
        var scheme = damages.find('.scheme svg');
        var fields = damages.find('.field');

        var fieldSuffix = '_damage';

        var selectionList = damages.find('ol.selection');
        var selectionRemoveText = damages.data('selectionRemoveText');

        // add new part to selection list
        var addSelectionItem = function(partId)
        {
            var part = jQuery('#' + partId);
            var partName = part.find('title').text();
            var selectionItem = jQuery('<li>' + partName + '<button class="remove" type="button" title="' +
                selectionRemoveText + '"><span class="text">' + selectionRemoveText + '</button></li>');

            selectionItem.data('partId', partId);
            selectionList.append(selectionItem);
        };

        // remove part from selection list
        var removeSelectionItem = function(partId)
        {
            var selectionItem = selectionList.find('li').filter(function()
            {
                return jQuery(this).data('partId') == partId;
            });

            selectionItem.remove();
        };

        var bindEvents = function()
        {
            scheme.on('part:toggle', '.part[id]', function(event, select)
            {
                var part = jQuery(event.target);
                var partId = part.attr('id');

                if (typeof select == 'undefined')
                {
                    select = !part.is('.selected');
                }

                part.toggleClass('selected', select);


                var input = fields.filter('[data-name="' + partId + fieldSuffix + '"]').find('input');

                input.prop('checked', select);


                if (select)
                {
                    addSelectionItem(partId);
                }
                else
                {
                    removeSelectionItem(partId);
                }
            });

            scheme.on('part:select', '.part[id]', function(event)
            {
                jQuery(event.target).trigger('part:toggle', true);
            });

            scheme.on('part:deselect', '.part[id]', function(event)
            {
                jQuery(event.target).trigger('part:toggle', false);
            });

            // handle clicks on svg scheme
            scheme.on('click', '.part[id]', function(event)
            {
                jQuery(this).trigger('part:toggle');
            });

            // handle checkbox change
            damages.on('change', 'input[type="checkbox"]', function(event)
            {
                var partId = jQuery(this).closest('.field').data('name').replace(fieldSuffix, '');

                jQuery('#' + partId).click();
            });

            damages.on('click', 'button.remove', function(event)
            {
                var item = jQuery(this).closest('li');
                var part = jQuery('#' + item.data('partId'));

                part.trigger('part:deselect');
            });
        };

        var initialize = function()
        {
            // create selection list
            if (!selectionList.length)
            {
                selectionList = jQuery('<ol class="selection">');
                damages.append(selectionList);
            }

            // append titles to vehicle parts
            scheme.find('.part[id]').each(function()
            {
                var part = jQuery(this);
                var partId = part.attr('id');
                var label = fields.filter('[data-name="' + partId + fieldSuffix + '"]').find('label').text();

                if (!label || part.find('title').length)
                {
                    return;
                }

                var title = document.createElementNS('http://www.w3.org/2000/svg', 'title');

                jQuery(title).text(label).appendTo(part);
            });

            bindEvents();

            fields.find('input:checked').trigger('change');
        };

        initialize();
    });

}());
