var isImage = function(href)
{
    return /\.(jp(e|g|eg)|gif|png|bmp|webp|svg)((\?|#).*)?$/i.test(href);
};

(function()
{
    'use strict';

    var page = jQuery(document);

    // preload hover images
    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        var images = block.find('img[data-hover-src]');

        images.each(function(index)
        {
            var image = jQuery(this);
            var hoverSrc = image.data('hoverSrc');

            if (!hoverSrc.length)
            {
                return;
            }

            var hoverImage = '<img class="hover" src="' + hoverSrc + '" alt=""/>';

            jQuery(hoverImage).on('load', function()
            {
                image.after(this);
            });
        });
    });

}());
