(function()
{
    'use strict';

    var page = jQuery(document);

    page.on('contentloaded', function(event)
    {
        var block = jQuery(event.target);

        block.find('.field[data-trigger]').each(function(index, field)
        {
            var target = jQuery(field);
            var trigger_name = target.attr('data-trigger');
            var inputs = target.find('input');
            var fields = block.find('[data-trigger-name=' + trigger_name + ']');

            if (!inputs.length || !fields.length)
            {
                return;
            }

            var changeValue = function()
            {
                fields.removeClass('selected');

                var value = inputs.filter(':checked').val() || 0;

                fields.filter('[data-trigger-value="' + value + '"]').addClass('selected');
            };

            inputs.on('change', changeValue);

            changeValue();
        });
    });

}());
